/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex;

import frc.emul.util.AddressBinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class VectrexAddrBinder
extends AddressBinder {
    public static final VectrexAddrBinder newDebugBinder() throws IOException {
        VectrexAddrBinder vectrexAddrBinder = new VectrexAddrBinder();
        vectrexAddrBinder.loadVectrexBindings();
        return vectrexAddrBinder;
    }

    public void loadVectrexBindings() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("frc/emul/vectrex/VECTREX.I");
        try {
            this.parse(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private void parse(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            char c;
            int n3 = (string = string.replace('\t', ' ').trim()).length();
            if (n3 == 0 || (c = string.charAt(0)) == ';' || c == '*' || (n2 = string.toUpperCase().indexOf(" EQU ")) < 0 || (n = string.toUpperCase().indexOf(36, n2)) < 0) continue;
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n + 1, n + 5);
            try {
                int n4 = Integer.parseInt(string3, 16);
                this.bind(n4, string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("*** Discarding invalid address \"" + string3 + "\" for \"" + string2 + "\"");
            }
        }
    }
}

